IF EXISTS ( SELECT * 
            FROM   sysobjects 
            WHERE  id = object_id(N'dbo.CP_Listas_Precios_Precio_Nuevo_Cargar') 
                   and OBJECTPROPERTY(id, N'IsProcedure') = 1 )
BEGIN
    DROP PROCEDURE dbo.CP_Listas_Precios_Precio_Nuevo_Cargar
END
GO


CREATE  PROCEDURE [dbo].[CP_Listas_Precios_Precio_Nuevo_Cargar] 
AS

DECLARE @Mensaje			VARCHAR(100)
		,@Id_Trans_Nueva	INT
		,@Descripcion		VARCHAR(100)
		,@Id_Valor			INT
		,@Comprobante_Nro	INT
		,@HacerBackup       TINYINT
		,@ListaBakcup       INT
		,@FECHA             DATETIME
		,@NroLista          INT
		,@ULTIMO_ERROR      INT

 DECLARE @Respuesta Table (
      ErrorNumber    int,
	  ErrorSeverity  INT,
	  ErrorState     INT,
	  ErrorProcedure INT,
	  ErrorLine      INT, 
      ErrorMessage   VARCHAR(100)
	  )		

BEGIN TRY
	

	IF (NOT EXISTS (SELECT 1 FROM Prod_Listas_Precios WHERE ISNULL(Job_Nombre,'') <> ''))
	BEGIN
		SELECT	 1					AS ErrorNumber 
				,0					AS ErrorSeverity  
				,0					AS ErrorState 
				,0					AS ErrorProcedure  
				,0					AS ErrorLine		
				,'No Existen listas con Job de actualizacion asociados'	AS ErrorMessage


		ROLLBACK
		RETURN 1
    END
	

        DECLARE CUR_PROCESAR_LISTAS CURSOR FOR

				SELECT Id_Lista_Precio,Flag_Hacer_Backup,Id_Lista_Precio_Backup,Fecha_Desde_Nueva
				FROM  Prod_Listas_Precios
				WHERE ACTIVO = 1 AND Isnull(Job_Nombre,'') <> ''  
				      AND Fecha_Desde_Nueva >= GETDATE() AND  Fecha_Desde_Nueva < GETDATE()+1

		  OPEN CUR_PROCESAR_LISTAS
		  FETCH NEXT FROM CUR_PROCESAR_LISTAS INTO  @NroLista,@HacerBackup,@ListaBakcup,@FECHA
	  
		  WHILE @@FETCH_STATUS = 0
			  BEGIN

				  EXEC @ULTIMO_ERROR =  CP_Listas_Precios_Precio_Nuevo_Actualizar @NroLista,@HacerBackup
				  IF @ULTIMO_ERROR <> 0
					 BEGIN
						 set @Mensaje = 'Error al ejecutar CP_Listas_Precios_Precio_Nuevo_Actualizar'
			 			 SELECT	 55					AS ErrorNumber 
								,0					AS ErrorSeverity  
								,0					AS ErrorState 
								,0					AS ErrorProcedure  
								,0					AS ErrorLine		
								,@Mensaje			AS ErrorMessage	

						 CLOSE CUR_PROCESAR_LISTAS
						 DEALLOCATE CUR_PROCESAR_LISTAS

						 RETURN 1
					 END				   
			   
  		          FETCH NEXT FROM CUR_PROCESAR_LISTAS INTO  @NroLista,@HacerBackup,@ListaBakcup,@FECHA
             END
		     CLOSE CUR_PROCESAR_LISTAS
		     DEALLOCATE CUR_PROCESAR_LISTAS


	SET @Mensaje = ''
	SELECT	 0					AS ErrorNumber 
			,0					AS ErrorSeverity  
			,0					AS ErrorState 
			,0					AS ErrorProcedure  
			,0					AS ErrorLine		
			,@Mensaje			AS ErrorMessage


END TRY  


BEGIN CATCH  
    EXECUTE usp_GetErrorInfo;  
	
END CATCH;   

